function [normimg] = imnorm(img,lim_in,lim_out,savram)
%This function is only valid for intensity images.  It takes the dynamic 
%range of an image and stretches it to the maximum image depth of the
%bit depth.  This does not take a percentage of the image pixels for
%normalization, if you want that use imadjust. More details about the
%equation: http://homepages.inf.ed.ac.uk/rbf/HIPR2/stretch.htm#1
%Synatax:   [normimg] = imnorm(img,[0 14759],[0 65525]); 
%Input:     img = the image or stack
%           lim_in = the dynamic range of the image [min max]
%           lim_out = the dynamic range of the image type, e.g., uint16.
%                   [min max]
%           savram = for situations where ram needs to be conserved, we
%               turn the single conversion off
%Output:    normimg = the normalized image.

%parse input
imgclass = class(img);      %get image type
if nargin==1||isempty(lim_in)||isempty(lim_out)
    lim_in = [absmin(img) absmax(img)];     %the min and max of the image or stack.
    %now figure out the image type of the image, not full proof, but works
    %most of the time.  Note: this assumes the images are unsigned.
    switch imgclass
        case 'uint8'
            lim_out = [0 intmax('uint8')];      %the image is unsigned 8bit
        case 'uint16'
            lim_out = [0 intmax('uint16')];     %the image is unsigned 16bit
        case 'uint32'
            lim_out = [0 intmax('uint32')];     %unsigned 32bit, like I said not full proof, but works for now.
        case 'double'
            lim_out = [0 1];        %double
    end
end
if nargin<4
    savram = 0; %default = off
end

%convert to single for arithmatic if not double
if ~strcmp('double',imgclass)&&~savram
    lim_out = single(lim_out);
    lim_in = single(lim_in);
    img = single(img);
end

%normalize:  The formula is: Po = (Pi - c)*((b-a)/(d-c))+a; Po = pixel out,
%Pi = Pixel in, a = MINout, b = MAXout, c = MINin, d = MAXin.
normfactor = (lim_out(2)-lim_out(1))/(lim_in(2)-lim_in(1));
normimg = ((img-lim_in(1)).*normfactor)+lim_in(1);

%convert back to integers
switch imgclass
    case 'uint8'
        normimg = uint8(normimg);      %the image is unsigned 8bit
    case 'uint16'
        normimg = uint16(normimg);     %the image is unsigned 16bit
    case 'uint32'
        normimg = uint32(normimg);     %unsigned 32bit, like I said not full proof, but works for now.
end